#ifndef LIBPDFTOIMAGE_OPTIONS_H
#define LIBPDFTOIMAGE_OPTIONS_H

#include <expected>
#include <filesystem>
#include <vector>

/**
 * std::filesystem::path pdfPath;
 * std::vector<std::filesystem::path> pageImagePaths;
 * std::string imageSize;
 * std::vector<int> pageIndexes;
 * int imageQuality;
*/
std::expected<
    std::tuple<
        std::filesystem::path,
        std::vector<std::filesystem::path>,
        std::vector<std::array<int, 2>>,
        std::vector<int>,
        int
    >,
    std::string
>
getOptions(int argc, char** argv);

#endif //LIBPDFTOIMAGE_OPTIONS_H