#ifndef LIBPDFTOIMAGE_READ_H
#define LIBPDFTOIMAGE_READ_H

#include <filesystem>
#include <vector>


int getPDFPageCount(const std::filesystem::path& pdfPath);
std::vector<std::array<double, 2>> getPageOriginalSizes(const std::filesystem::path& pdfPath, const std::vector<int>& pageIndexes);
std::tuple<std::vector<unsigned char>, int> getPDFPageBuffer(
    const std::filesystem::path& pdfPath, const int& actualPageIndex, const int& renderingWidth, const int& renderingHeight
    );

#endif //LIBPDFTOIMAGE_READ_H