#include <string>
#include <vector>

#ifdef _WIN32
#include <windows.h>

#include "specific_os.h"
#endif

#include "help.h"
#include "options.h"
#include "save_pdf.h"


int main(int argc, char *argv[]) {
    std::vector<std::string> argVector;

#ifdef _WIN32
    SetConsoleOutputCP(CP_UTF8);
    SetConsoleCP(CP_UTF8);

    argVector = SpecificOS::getArgvFromWchar();
#else
    for (int i = 0; i < argc; ++i) {
        std::string arg = argv[i];
        argVector.emplace_back(arg);
    }
#endif

    if (argc == 1) {
        Help::showHelp("--help");
        return 0;
    }

    for (const auto& arg : argVector) {
        if (arg == "-h" || arg == "-v" || arg == "--help") {
            Help::showHelp(arg);
            return 0;
        }
    }

    auto getOptionsResult = Options::getOptions(argc, argVector);

    if (getOptionsResult.has_value()) {
        auto [
            imagePaths,
            pdfPath,
            paperSize,
            outputWidth,
            outputQuality,
            imageNumberPerPage,
            margins,
            spacings
        ] = getOptionsResult.value();

        if (SavePDF::createPDF(
            imagePaths,
            pdfPath,
            paperSize,
            outputWidth,
            outputQuality,
            imageNumberPerPage,
            margins,
            spacings)
        ) {
            std::cout << "PDF created successfully!\n";
        } else {
            std::cout << "Failed to create PDF\n";
        }
    } else {
        std::cout << getOptionsResult.error() << std::endl;;
    }

    return 0;
}