#ifndef LIBIMAGETOPDF_HANDLE_IMAGE_H
#define LIBIMAGETOPDF_HANDLE_IMAGE_H

#include <string>
#include <vector>
#include <filesystem>

class HandleImage {

public:
    struct ImageData {
        std::vector<unsigned char> data;
        int width;
        int height;
        int channels;
        int xDpi;
        int yDpi;
        std::string type;
    };

    static void handleImage(
        const std::filesystem::path& imagePath,
        ImageData& imageData,
        const std::array<int, 2>& paperSize,
        const int& outputWidth,
        const int& outputQuality
    );

private:

    static void rotateImage(ImageData& imageData, const int& angle);
    static void resizeImage(ImageData& imageData, const int& newWidth);

    static void readJPEG(const std::filesystem::path& imagePath, ImageData& imageData);
    static void decodeJPEG(ImageData& imageData);
    static void compressJPEG(ImageData& imageData, const int& imageQuality);

    static void readPNG(const std::filesystem::path& imagePath, ImageData& imageData);
    static void readRGBFromPNG(ImageData& imageData);
    static void compressPNG(ImageData& imageData);

};

#endif //LIBIMAGETOPDF_HANDLE_IMAGE_H