#ifndef LIBAICONNECT_OPTIONS_H
#define LIBAICONNECT_OPTIONS_H

#include <iostream>
#include <vector>
#include <unordered_map>

class Options {

public:

    static std::array<std::string, 6> getOptions(int argc, const std::vector<std::string>& argVector);

private:

    static std::string selectProvider(const std::string& purpose);

    static std::string selectKey(
        const std::unordered_map<std::string, std::string>& keys,
        const std::string& purpose
    );

    static std::string selectModel(
        const std::unordered_map<std::string, std::unordered_map<std::string, std::string>>& models,
        const std::string& purpose
    );

    static std::string selectRole(
        const std::unordered_map<std::string, std::array<std::string, 2>>& roles,
        const std::string& purpose
    );

    static std::string receiveMultiLines();
};

#endif //LIBAICONNECT_OPTIONS_H