#include <iostream>
#include <ranges>
#include <filesystem>

#ifdef _WIN32
#include <windows.h>

#include "specific_os.h"
#endif

#include "options.h"
#include "help.h"
#include "net.h"


int main(int argc, char *argv[]) {
    std::vector<std::string> argVector;

#ifdef _WIN32
    SetConsoleOutputCP(CP_UTF8);
    SetConsoleCP(CP_UTF8);

    argVector = SpecificOS::getArgvFromWchar();
#else
    for (int i = 0; i < argc; ++i) {
        std::string arg = argv[i];
        argVector.emplace_back(arg);
    }
#endif

    if (argc == 1) {
        Help::showHelp("--help");
        return 0;
    }

    for (const auto& arg : argVector) {
        if (arg == "-h" || arg == "-v" || arg == "--help") {
            Help::showHelp(arg);
            return 0;
        }
    }

    auto [
        connectionProvider,
        connectionKey,
        connectionModel,
        connectionRoleInstruction,
        connectionDetailedInstructions,
        connectionContent
        ] = Options::getOptions(argc, argVector);

    if (connectionKey.empty() || connectionModel.empty() || connectionContent.empty()) {
        std::cout << "Exited without any API connection." << std::endl;
        return 0;
    }

    std::cout << "An API connection is started. Please wait for the AI's reply." << std::endl;

    auto reply = Net::aiDispatcher(
        connectionProvider,
        connectionKey,
        connectionModel,
        connectionRoleInstruction,
        connectionDetailedInstructions,
        connectionContent);

    if (reply.has_value()) {
        std::cout << reply.value() << std::endl;
    } else {
        std::cout << reply.error() << std::endl;
    }

    return 0;
}
