#ifndef LIBAICONNECT_CONFIG_H
#define LIBAICONNECT_CONFIG_H

#include <vector>
#include <filesystem>
#include <unordered_map>


class Config {

public:

    static std::vector<std::string> supportedProviders;

    static bool saveConf(const std::string& optionName, const std::string& optionValue);

    static std::tuple<
        std::unordered_map<std::string, std::string>,
        std::unordered_map<std::string, std::unordered_map<std::string, std::string>>,
        std::unordered_map<std::string, std::array<std::string, 2>>
    >
    loadConf(const std::string& purpose);

    static std::unordered_map<std::string, std::string> recognizeKeys(const std::string& parameterValue);

    static std::unordered_map<std::string, std::unordered_map<std::string, std::string>>
    recognizeModels(const std::string& parameterValue);

    static std::unordered_map<std::string, std::array<std::string, 2>>
    recognizeRole(std::string parameterValue, const std::string& purpose);

    static std::string cleanString(std::string string);

private:

    static std::filesystem::path getConfPath();

};

#endif //LIBAICONNECT_CONFIG_H