#include <iostream>
#include <ranges>
#include <filesystem>

#include "options.h"
#include "help.h"
#include "net.h"


int main(int argc, char *argv[])
{
    if (argc == 1) {
        Help::showHelp("--help");
        return 0;
    }

    for (int i = 1; i < argc; ++i) {
        std::string arg = argv[i];
        if (arg == "-h" || arg == "-v" || arg == "--help") {
            Help::showHelp(argv[i]);
            return 0;
        }
    }

    auto [
        connectionProvider,
        connectionKey,
        connectionModel,
        connectionRoleInstruction,
        connectionDetailedInstructions,
        connectionContent
        ] = Options::getOptions(argc, argv);

    if (connectionKey.empty() || connectionModel.empty() || connectionContent.empty()) {
        std::cout << "Exited without any API connection." << std::endl;
        return 0;
    }

    std::cout << "An API connection is started. Please wait for the AI's reply." << std::endl;

    auto reply = Net::aiDispatcher(
        connectionProvider,
        connectionKey,
        connectionModel,
        connectionRoleInstruction,
        connectionDetailedInstructions,
        connectionContent);

    if (reply.has_value()) {
        std::cout << reply.value() << std::endl;
    } else {
        std::cout << reply.error() << std::endl;
    }

    return 0;
}
